<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudSearch;

class AppsDynamiteV1ApiCompatV1Action extends \Google\Model
{
  protected $confirmType = AppsDynamiteV1ApiCompatV1ActionConfirm::class;
  protected $confirmDataType = '';
  public $confirm;
  /**
   * @var string
   */
  public $name;
  /**
   * @var string
   */
  public $style;
  /**
   * @var string
   */
  public $text;
  /**
   * @var string
   */
  public $type;
  /**
   * @var string
   */
  public $value;

  /**
   * @param AppsDynamiteV1ApiCompatV1ActionConfirm
   */
  public function setConfirm(AppsDynamiteV1ApiCompatV1ActionConfirm $confirm)
  {
    $this->confirm = $confirm;
  }
  /**
   * @return AppsDynamiteV1ApiCompatV1ActionConfirm
   */
  public function getConfirm()
  {
    return $this->confirm;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param string
   */
  public function setStyle($style)
  {
    $this->style = $style;
  }
  /**
   * @return string
   */
  public function getStyle()
  {
    return $this->style;
  }
  /**
   * @param string
   */
  public function setText($text)
  {
    $this->text = $text;
  }
  /**
   * @return string
   */
  public function getText()
  {
    return $this->text;
  }
  /**
   * @param string
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * @param string
   */
  public function setValue($value)
  {
    $this->value = $value;
  }
  /**
   * @return string
   */
  public function getValue()
  {
    return $this->value;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AppsDynamiteV1ApiCompatV1Action::class, 'Google_Service_CloudSearch_AppsDynamiteV1ApiCompatV1Action');
